#include "sound.h"

Sound::Sound()
{
	_buffer = 0;
	_source = 0;

	_loaded = false;
	_played = false;

	_volume = 1.0f;
	_dTime = 0.f;
}


void Sound::loadFromFile(string path)
{
	if (_loaded) clear();

	_buffer = alutCreateBufferFromFile(path.c_str());
	alGenSources(1, &_source);

	alSourcei(_source, AL_BUFFER, _buffer);
	_loaded = true;
}


void Sound::play()
{
	if (_loaded)
	{
		ALint status;
		alGetSourcei(_source, AL_SOURCE_STATE, &status);
		alSourcef(_source, AL_GAIN, _volume);

		if (status != AL_PLAYING) alSourcePlay(_source);
	}
}


void Sound::playOnce()
{
	if (_loaded && !_played)
	{
		alSourcef(_source, AL_GAIN, _volume);
		alSourcePlay(_source);
		_played = true;
	}
}


void Sound::stop()
{
	if (_loaded)
	{
		alSourceStop(_source);
		_played = false;
	}
}


void Sound::setVolume(float volume)
{
	_volume = volume;
}


void Sound::clear()
{
	alSourceStop(_source);
	alSourcei(_source, AL_BUFFER, 0);
	alDeleteSources(1, &_source);
	alDeleteBuffers(1, &_buffer);

	if (alIsBuffer(_buffer))
	{
		cout << "Buffer still exists" << endl;
	}

	_loaded = false;
	_played = false;
}


Sound::~Sound()
{
	if (_loaded) clear();
}
