#include "player.h"
#include "application.h"

Player::Player()
{
	_texture.loadFromFile("data/graphics/cell.png");

	_sprite.setTexture(_texture, true);
	_sprite.setPosition(50, 50);
	_sprite.setOrigin(7, 7);

	_cursorPos.x = 0;
	_cursorPos.y = 0;

	_timer = 0.f;
	_frame = 0;
}


void Player::setApp(Application *app)
{
	_app = app;
	_rWindow = _app->getRenderWindow();
}


void Player::display()
{
	static bool sFrame = false;
	sf::Vector2<float> velocity(0, 0);
	_cursorPos = _app->getCursorPosition();
	_timer += _app->getDeltaTime();

	if (_timer >= 0.1f)
	{
		if (_cursorPos.x < _sprite.getPosition().x - 3) velocity.x = -2;
		else if (_cursorPos.x > _sprite.getPosition().x + 3) velocity.x = 2;

		if (_cursorPos.y < _sprite.getPosition().y - 3) velocity.y = -2;
		else if (_cursorPos.y > _sprite.getPosition().y + 3) velocity.y = 2;

		if (sFrame)
		{
			_frame = !_frame;
			sFrame = false;
		}
		else sFrame = true;
		_timer = 0.f;

		int rpx = _sprite.getPosition().x + velocity.x;
		int rpy = _sprite.getPosition().y + velocity.y;
		if (rpy < 25 || rpy > 119) velocity.y = 0;

		int s = _app->getScene();
		if (s == S_H1_I || s == S_H2_I || s == S_H3_I || s == S_CHURCH_I)
		{
			if (rpx < 25 || rpx > 167) velocity.x = 0;
		}
		else if (s == S_H1)
		{
			if (rpx < 15) velocity.x = 0;
		}
		else if (s == S_TUNNEL)
		{
			if (rpx > 167) velocity.x = 0;
			if (rpy < 36) velocity.y = 0;
		}
		else if (s == S_H4_1)
		{
			if (rpx > 167) velocity.x = 0;
			if (rpy < 45) velocity.y = 0;
		}
		else if (s == S_H4_2)
		{
			if (rpx < 25) velocity.x = 0;
			if (rpy < 45) velocity.y = 0;
		}
		else if (s == S_CHURCH)
		{
			if (rpx > 167) velocity.x = 0;
		}
	}

	_sprite.setTextureRect(sf::Rect<int>(0, _frame * 16, 16, 16));
	if (!_app->getFade())_sprite.move(velocity);
	_rWindow->draw(_sprite);

	//cout << "M.x:" << _cursorPos.x << "; M.y:" << _cursorPos.y << endl;
	//cout << "P.x:" << _sprite.getPosition().x << "; P.y:" << _sprite.getPosition().y << endl;
}


bool Player::getInside(sf::Rect<int> box)
{

	if (_sprite.getPosition().x > box.left && _sprite.getPosition().x < box.width
		&& _sprite.getPosition().y > box.top && _sprite.getPosition().y < box.height
		&& _cursorPos.x > box.left && _cursorPos.x < box.width
		&& _cursorPos.y > box.top && _cursorPos.y < box.height)
	{
		return true;
	}
	else return false;
}


sf::Sprite* Player::getSprite()
{
	return &_sprite;
}


Player::~Player()
{
}
