#ifndef DEF_APP
#define DEF_APP

#include "player.h"

enum SCENES
{
	S_NONE,
	S_INTRO,
	S_TITLE,
	S_H1,
	S_H1_I,
	S_H2,
	S_H2_I,
	S_H3,
	S_H3_I,
	S_TUNNEL,
	S_H4_1,
	S_H4_2,
	S_CHURCH,
	S_CHURCH_I,
	S_HOSPITAL,
	S_COUNT
};

class Application
{
	public:
		Application();
		int exec();
		void draw();
		void script();
		void handleEvent();
		void setScene(int NewScene, bool fade = false);
		~Application();

		int getScene() const;
		int getFade() const;
		sf::Vector2<float> getCursorPosition() const;
		sf::RenderWindow* getRenderWindow();
		float getDeltaTime() const;

	private:
		sf::RenderWindow _rWindow;
		sf::View _view;

        sf::Texture _cursorTexture;
		sf::Sprite _cursorSprite;
		sf::Vector2<float> _cursorPosition;

		sf::Clock _deltaClock;

        sf::Image _dImage;

		sf::Texture _bgTexture;
		sf::Texture _fgTexture;
		sf::Texture _dTexture;
		sf::Texture _filterTexture;
		sf::Texture _fogTexture;

		sf::Sprite _bgSprite;
		sf::Sprite _fgSprite;
		sf::Sprite _dSprite;
		sf::Sprite _filterSprite;
		sf::Sprite _fogSprite;

        sf::Image _fadeImage;
		sf::Texture _fadeTexture;
		sf::Sprite _fadeSprite;

		sf::Texture _doorTexture;
		sf::Texture _tunnelTexture;
		sf::Texture _bedTexture;
		sf::Sprite _doorSprite;
		sf::Sprite _tunnelSprite;
		sf::Sprite _bedSprite;

		Sound _corruptionSound;
		Sound _heartbeatSound;
		Sound _bipSound;
		Sound _lightSound;

		Sound _cellMusic;
		Sound _cavernMusic;
		Sound _tunnelMusic;

		Player _player;
		sf::Vector2<float> _startPosition;

		int _scene;
		int _newScene;
		bool _foreground;

		bool _fullscreen;
		bool _load;
		bool _interact;

		float _dTime, _timer0, _timer1;

		float _fogTimer;
		int _fogX;

		float _fadeTimer;
		int _fadeLevel;
		int _fade;

		bool _h3corrupted;
		bool _h4corrupted;
};

#endif
