#include "application.h"

Application::Application()
{
	_rWindow.create(sf::VideoMode(768, 576), "Crab", sf::Style::Close);
	_rWindow.setVerticalSyncEnabled(false);
	_view.setCenter(96, 72);
	_view.setSize(192, 144);
	_rWindow.setView(_view);
	_rWindow.setMouseCursorVisible(false);

	alutInit(0, 0);
	if (alutGetError() != ALUT_ERROR_NO_ERROR)
	{
		cout << "Error on ALUT Initialization !" << endl;
		_rWindow.close();
	}

	_fullscreen = false;
	_load = false;

//	_CursorImage.Create(1, 1, sf::Color(255, 0, 0));
	_cursorTexture.loadFromFile("data/graphics/cursor.png");
	_cursorSprite.setTexture(_cursorTexture);
	_cursorSprite.setOrigin(3, 3);
	_cursorPosition.x = 0;
	_cursorPosition.y = 0;

	_filterTexture.loadFromFile("data/graphics/filter.png");
	_filterSprite.setTexture(_filterTexture);

	_fogTexture.loadFromFile("data/graphics/fog.png");
	_fogSprite.setTexture(_fogTexture);
	_fogTimer = 0.f;
	_fogX = 0;

	_fadeImage.create(192, 144, sf::Color(0, 0, 0, 0));
	_fadeTexture.loadFromImage(_fadeImage);
	_fadeSprite.setTexture(_fadeTexture);
	_fadeTimer = 0.f;
	_fadeLevel = 0;
	_fade = 0;

	_doorTexture.loadFromFile("data/graphics/dooricn.bmp");
	_doorSprite.setTexture(_doorTexture);
	_doorSprite.setPosition(90, 132);

	_tunnelTexture.loadFromFile("data/graphics/tunnelicn.bmp");
	_tunnelSprite.setTexture(_tunnelTexture);
	_tunnelSprite.setPosition(90, 132);

	_bedTexture.loadFromFile("data/graphics/bedicn.bmp");
	_bedSprite.setTexture(_bedTexture);
	_bedSprite.setPosition(90, 132);

	_player.setApp(this);
	_startPosition.x = 50;
	_startPosition.y = 50;
	_scene = S_INTRO;
	_newScene = S_NONE;

	_corruptionSound.loadFromFile("data/sounds/corruption.wav");
	_heartbeatSound.loadFromFile("data/sounds/heartbeat.wav");
	_bipSound.loadFromFile("data/sounds/bip.wav");
	_lightSound.loadFromFile("data/sounds/light_hum.wav");

	_tunnelMusic.loadFromFile("data/sounds/tunnel.wav");
	_cavernMusic.loadFromFile("data/sounds/cavern.wav");
	_cellMusic.loadFromFile("data/sounds/cell.wav");

	_foreground = false;
	_interact = false;

	_h3corrupted = false;
	_h4corrupted = false;

	_deltaClock.restart();
}


int Application::exec()
{
	draw();
	return EXIT_SUCCESS;
}


void Application::draw()
{
	while (_rWindow.isOpen())
	{
	    sf::Time t = _deltaClock.getElapsedTime();
	    _dTime = t.asSeconds();
	    cout << _dTime << endl;
	    _deltaClock.restart();

		_interact = false;
		handleEvent();

		if (_scene == S_H1 || _scene == S_H1_I || _scene == S_H2 || _scene == S_TUNNEL) _cavernMusic.play();
		else _cavernMusic.stop();

		if (_scene == S_H4_1 || _scene == S_H4_2) _tunnelMusic.play();
		else _tunnelMusic.stop();

		if (_scene == S_H2 || _scene == S_H2_I || _scene == S_H3) _cellMusic.play();
		else _cellMusic.stop();

		if (_scene == S_CHURCH) _heartbeatSound.play();
		else if (_scene != S_CHURCH_I) _heartbeatSound.stop();

		if (_scene == S_HOSPITAL) _bipSound.playOnce();
		else _bipSound.stop();

		_rWindow.clear(sf::Color(0, 0, 0));
		_rWindow.draw(_bgSprite);

		script();
		if (_scene != S_HOSPITAL && _scene != S_INTRO && _scene != S_TITLE) _player.display();
		if (_scene == S_H1 || _scene == S_H2 || _scene == S_H3 || _scene == S_CHURCH)
		{
			_fogTimer += _dTime;
			if (_fogTimer >= 0.2f)
			{
				_fogX += 1;
				if (_fogX == 576) _fogX = 0;
				_fogTimer = 0.f;
			}
			_fogSprite.setTextureRect(sf::Rect<int>(_fogX, 0, 192, 144));
			_rWindow.draw(_fogSprite);
		}
		if (_foreground) _rWindow.draw(_fgSprite);
		if (_scene != S_HOSPITAL && _scene != S_INTRO && _scene != S_TITLE) _rWindow.draw(_cursorSprite);
		_rWindow.draw(_filterSprite);

		if (_newScene != S_NONE)
		{
			if (_fade == 1)
			{
				_fadeTimer += _dTime;
				if (_fadeTimer > 0.4f)
				{
					_fadeTimer = 0.8f;
					_scene = _newScene;
					_load = false;
					_fade = 2;
				}
			}
			else if (_fade == 2)
			{
				_fadeTimer -= _dTime;
				if (_fadeTimer <= 0.f)
				{
					_fadeTimer = 0.f;
					_newScene = S_NONE;
					_fade = 0;
				}
			}
			else
			{
				_scene = _newScene;
				_newScene = S_NONE;
				_load = false;
			}
		}

		if (_fadeTimer)
		{
			if (_fadeTimer >= 0.4f) _fadeLevel = 255;
			else if (_fadeTimer >= 0.3f) _fadeLevel = 192;
			else if (_fadeTimer >= 0.2f) _fadeLevel = 128;
			else if (_fadeTimer >= 0.1f) _fadeLevel = 64;
			else _fadeLevel = 0;

			_fadeImage.create(192, 144, sf::Color(0, 0, 0, _fadeLevel));
			_fadeTexture.loadFromImage(_fadeImage);
			_fadeSprite.setTexture(_fadeTexture);
			_rWindow.draw(_fadeSprite);
		}

		_rWindow.display();
	}
}


void Application::script()
{
	if (!_load)
	{
		_player.getSprite()->setPosition(_startPosition);

		if (_scene == S_INTRO)
		{
		    cout << "Loaded!" << endl;
			_bgTexture.loadFromFile("data/graphics/intro.png");
			_foreground = false;
		}
		else if (_scene == S_TITLE)
		{
			_bgTexture.loadFromFile("data/graphics/title.png");
			_foreground = false;
		}
		else if (_scene == S_H1)
		{
			_bgTexture.loadFromFile("data/graphics/h1.png");
			_fgTexture.loadFromFile("data/graphics/h1_fg.png");
			_foreground = true;
			_cavernMusic.setVolume(0.8f);
		}
		else if (_scene == S_H1_I)
		{
			_bgTexture.loadFromFile("data/graphics/h1_i.png");
			_fgTexture.loadFromFile("data/graphics/h1_i_fg.png");
			_foreground = true;
			_cavernMusic.setVolume(1.f);
		}
		else if (_scene == S_H2)
		{
			_bgTexture.loadFromFile("data/graphics/h2.png");
			_fgTexture.loadFromFile("data/graphics/h2_fg.png");
			_foreground = true;
		}
		else if (_scene == S_H2_I)
		{
			_bgTexture.loadFromFile("data/graphics/h2_i.png");
			_foreground = false;
			_dImage.create(1, 1, sf::Color(8, 8, 8));
			_dTexture.loadFromImage(_dImage);
			_dSprite.setTexture(_dTexture);
			_timer0 = 0.f;
			_timer1 = 0.f;
		}
		else if (_scene == S_H3)
		{
			if (_h3corrupted)
				_bgTexture.loadFromFile("data/graphics/h3_c.png");
			else
				_bgTexture.loadFromFile("data/graphics/h3.png");
			_cellMusic.setVolume(1.f);
			_fgTexture.loadFromFile("data/graphics/h3_fg.png");
			_foreground = true;
		}
		else if (_scene == S_H3_I)
		{
			if (_h3corrupted)
			{
				_bgTexture.loadFromFile("data/graphics/h3_i_c.png");
				_fgTexture.loadFromFile("data/graphics/h3_i_fg_c.png");
			}
			else
			{
				_bgTexture.loadFromFile("data/graphics/h3_i.png");
				_fgTexture.loadFromFile("data/graphics/h3_i_fg.png");
			}
			_foreground = true;
		}
		else if (_scene == S_TUNNEL)
		{
			if (_h4corrupted)
				_bgTexture.loadFromFile("data/graphics/tunnel_c.png");
			else
				_bgTexture.loadFromFile("data/graphics/tunnel.png");
			_fgTexture.loadFromFile("data/graphics/tunnel_fg0.png");
			_foreground = true;
			_timer0 = 0.f;
		}
		else if (_scene == S_H4_1)
		{
			if (_h4corrupted)
				_bgTexture.loadFromFile("data/graphics/h4_1_c.png");
			else
				_bgTexture.loadFromFile("data/graphics/h4_1.png");
			_foreground = false;
			_timer0 = 0.f;
		}
		else if (_scene == S_H4_2)
		{
			if (_h4corrupted)
				_bgTexture.loadFromFile("data/graphics/h4_2_c.png");
			else
				_bgTexture.loadFromFile("data/graphics/h4_2.png");
			_foreground = false;
			_timer0 = 0.f;
		}
		else if (_scene == S_CHURCH)
		{
			_bgTexture.loadFromFile("data/graphics/church.png");
			_fgTexture.loadFromFile("data/graphics/church_fg.png");
			_foreground = true;
			_heartbeatSound.setVolume(0.5f);

			_dTexture.loadFromFile("data/graphics/proliferation.png");
			_dSprite.setTexture(_dTexture);
			_dSprite.setPosition(84, 73);
		}
		else if (_scene == S_CHURCH_I)
		{
			_bgTexture.loadFromFile("data/graphics/church_i.png");
			_fgTexture.loadFromFile("data/graphics/church_i_fg.png");
			_foreground = true;
			_heartbeatSound.stop();
			_heartbeatSound.setVolume(1.f);

			_dTexture.loadFromFile("data/graphics/heart.png");
			_dSprite.setTexture(_dTexture);
			_dSprite.setPosition(92, 64);
		}
		else if (_scene == S_HOSPITAL)
		{
			_bgTexture.loadFromFile("data/graphics/hospital.png");
			_foreground = false;

			_timer0 = 0.f;
		}

		_bgSprite.setTexture(_bgTexture, true);

		if (_foreground) _fgSprite.setTexture(_fgTexture, true);

		_load = true;
	}

	if (_scene == S_INTRO)
	{
		if (_interact) setScene(S_TITLE, true);
	}
	if (_scene == S_TITLE)
	{
		if (_interact) setScene(S_H2_I, true);
	}
	else if (_scene == S_H1)
	{
		if (_player.getSprite()->getPosition().x > 182)
		{
				setScene(S_H2);
				_startPosition.x = 15;
				_startPosition.y = _player.getSprite()->getPosition().y;
		}
		if (_player.getInside(sf::Rect<int>(49, 80, 70, 112)))
		{
			_rWindow.draw(_doorSprite);
			if (_interact)
			{
				setScene(S_H1_I, true);
				_startPosition.x = 36;
				_startPosition.y = 100;
			}
		}
		if (_player.getInside(sf::Rect<int>(115, 41, 164, 112)))
		{
			_rWindow.draw(_tunnelSprite);
			if (_interact)
			{
				setScene(S_TUNNEL, true);
				_startPosition.x = 15;
				_startPosition.y = 100;
			}
		}
	}
	else if (_scene == S_H1_I)
	{
		if (_player.getInside(sf::Rect<int>(26, 84, 47, 116)))
		{
			_rWindow.draw(_doorSprite);
			if (_interact)
			{
				setScene(S_H1, true);
				_startPosition.x = 59;
				_startPosition.y = 96;
			}
		}
	}
	else if (_scene == S_H2)
	{
		int xPos = _player.getSprite()->getPosition().x;
		if (xPos > 80) xPos = 80;
		float factor = (float) xPos / 80.f;
		factor *= 0.8f;
		factor = 0.8f - factor;
		_cavernMusic.setVolume(factor);

		if (_player.getSprite()->getPosition().x < 10)
		{
			setScene(S_H1);
			_startPosition.x = 177;
			_startPosition.y = _player.getSprite()->getPosition().y;
		}

		if (_player.getSprite()->getPosition().x > 182)
		{
			setScene(S_H3);
			_startPosition.x = 15;
			_startPosition.y = _player.getSprite()->getPosition().y;
		}

		if (_player.getInside(sf::Rect<int>(153, 80, 174, 112)))
		{
			_rWindow.draw(_doorSprite);
			if (_interact)
			{
				setScene(S_H2_I, true);
				_startPosition.x = 36;
				_startPosition.y = 100;
			}
		}
	}
	else if (_scene == S_H2_I)
	{
		if (_timer0 < 3.f)
		{
			_timer0 += _dTime;
			if (_timer0 >= 3.f)
			{
				_dSprite.setPosition(134, 88);
				_timer1 = 0.f;
			}
		}
		else
		{
			_timer1 += _dTime;

			int off = 88 + _timer1 * 50.f;
			_dSprite.setPosition(134, off);
			if (off >= 116)
			{
				_timer0 = 0.f;
			}
			_rWindow.draw(_dSprite);
		}

		if (_player.getInside(sf::Rect<int>(26, 84, 47, 116)))
		{
			_rWindow.draw(_doorSprite);
			if (_interact)
			{
				setScene(S_H2, true);
				_startPosition.x = 163;
				_startPosition.y = 96;
			}
		}
	}
	else if (_scene == S_H3)
	{
		if (_player.getSprite()->getPosition().x < 10)
		{
			setScene(S_H2);
			_startPosition.x = 177;
			_startPosition.y = _player.getSprite()->getPosition().y;
		}

		if (_player.getSprite()->getPosition().x > 182)
		{
			setScene(S_CHURCH);
			_startPosition.x = 15;
			_startPosition.y = _player.getSprite()->getPosition().y;
		}

		if (_player.getInside(sf::Rect<int>(105, 80, 126, 112)))
		{
			_rWindow.draw(_doorSprite);
			if (_interact)
			{
				setScene(S_H3_I, true);
				_startPosition.x = 36;
				_startPosition.y = 100;
			}
		}
	}
	else if (_scene == S_H3_I)
	{
		if (_player.getInside(sf::Rect<int>(26, 84, 47, 116)))
		{
			_rWindow.draw(_doorSprite);
			if (_interact)
			{
				setScene(S_H3, true);
				_startPosition.x = 115;
				_startPosition.y = 96;
			}
		}

		static int h3fl = 0;
		if (!_h3corrupted && _player.getInside(sf::Rect<int>(137, 107, 175, 128)))
		{
			_rWindow.draw(_bedSprite);
			if (_interact)
			{
				h3fl = 1;
			}
		}
		if (h3fl == 1)
		{
			_fadeTimer += _dTime;

			if (_fadeTimer >= 2.f)
			{
				_corruptionSound.stop();
				_corruptionSound.playOnce();
				_h3corrupted = true;
				setScene(S_H3_I);
				_startPosition.x = 157;
				_startPosition.y = 117;
				h3fl = 2;
				_fadeTimer = 0.5f;
			}
		}
		else if (h3fl == 2)
		{
			_fadeTimer -= _dTime / 10.f;
			if (_fadeTimer <= 0.f)
			{
				_fadeTimer = 0.f;
				h3fl = 0;
			}
		}
	}
	else if (_scene == S_TUNNEL)
	{
		static bool flash = false;
		static float flashSeq = 2.f;
		static float flashDuration = 0.2f;
		static int seq = 0;

		_timer0 += _dTime;
		if (flashSeq != 0.f)
		{
			if (_timer0 > flashSeq && !flash)
			{
				_lightSound.play();
				_fgTexture.loadFromFile("data/graphics/tunnel_fg1.png");
				_fgSprite.setTexture(_fgTexture);
				flash = true;
			}
			else if (_timer0 > flashSeq + flashDuration && flash)
			{
				_lightSound.stop();
				_fgTexture.loadFromFile("data/graphics/tunnel_fg0.png");
				_fgSprite.setTexture(_fgTexture);
				flash = false;
				_timer0 = 0.f;
				seq++;

				if (seq == 1) {
					flashSeq = 1.f;
					flashDuration = 0.1f;
				} else if (seq == 2) {
					flashSeq = 3.f;
					flashDuration = 0.1f;
				} else if (seq == 3) {
					flashSeq = 0.5f;
					flashDuration = 0.2f;
				} else if (seq == 4) {
					flashSeq = 0.5f;
					flashDuration = 0.2f;
				} else if (seq == 5) {
					flashSeq = 0.5f;
					flashDuration = 0.2f;
				} else if (seq == 6) {
					flashSeq = 2.75f;
					flashDuration = 0.1f;
				} else if (seq == 7) {
					flashSeq = 1.f;
					flashDuration = 0.2f;
				} else if (seq == 8) {
					flashSeq = 0.8f;
					flashDuration = 0.2f;
				} else if (seq == 9) {
					flashSeq = 1.2f;
					flashDuration = 0.1f;
				} else if (seq == 10) {
					flashSeq = 3.f;
					flashDuration = 0.1f;
				} else if (seq == 11) {
					flashSeq = 1.5f;
					flashDuration = 0.2f;
				} else if (seq == 12) {
					flashSeq = 0.5f;
					flashDuration = 0.1f;
				} else if (seq == 13) {
					flashSeq = 0.75f;
					flashDuration = 0.1f;
				} else if (seq == 14) {
					flashSeq = 3.f;
					flashDuration = 0.1f;
				} else if (seq == 15) {
					flashSeq = 0.75f;
					flashDuration = 0.2f;
				} else if (seq == 16) {
					flashSeq = 3.75f;
					flashDuration = 0.1f;
				} else if (seq == 17) {
					flashSeq = 0.75f;
					flashDuration = 0.1f;
				} else if (seq == 18) {
					flashSeq = 1.f;
					flashDuration = 0.1f;
				} else if (seq == 19) {
					flashSeq = 4.f;
					flashDuration = 0.1f;
				} else if (seq == 20) {
					flashSeq = 0.5f;
					flashDuration = 0.1f;
				} else if (seq == 21) {
					flashSeq = 3.5f;
					flashDuration = 0.1f;
				} else if (seq == 22) {
					flashSeq = 0.5f;
					flashDuration = 0.2f;
				} else if (seq == 23) {
					flashSeq = 0.f;
				}
			}
		}

		int xPos = _player.getSprite()->getPosition().x;
		if (xPos > 100) xPos = 100;
		float factor = (float) xPos / 100.f;
		factor *= 0.5f;
		factor = 0.8f - factor;
		_cavernMusic.setVolume(factor);

		if (_player.getSprite()->getPosition().x < 10)
		{
			setScene(S_H1, true);
			_startPosition.x = 140;
			_startPosition.y = 82;
		}

		if (_player.getInside(sf::Rect<int>(131, 84, 152, 116)))
		{
			_rWindow.draw(_doorSprite);
			if (_interact)
			{
				setScene(S_H4_1, true);
				_startPosition.x = 155;
				_startPosition.y = 100;
			}
		}
	}
	else if (_scene == S_H4_1)
	{
		if (_player.getSprite()->getPosition().x < 10)
		{
			setScene(S_H4_2);
			_startPosition.x = 177;
			_startPosition.y = _player.getSprite()->getPosition().y;
		}

		if (_player.getInside(sf::Rect<int>(144, 84, 165, 116)))
		{
			_rWindow.draw(_doorSprite);
			if (_interact)
			{
				setScene(S_TUNNEL, true);
				_startPosition.x = 142;
				_startPosition.y = 100;
			}
		}
	}
	else if (_scene == S_H4_2)
	{
		static int h4fl = 0;
		if (!_h4corrupted && _player.getInside(sf::Rect<int>(17, 107, 55, 128)))
		{
			_rWindow.draw(_bedSprite);
			if (_interact)
			{
				h4fl = 1;
			}
		}
		if (_player.getSprite()->getPosition().x > 182)
		{
			setScene(S_H4_1);
			_startPosition.x = 15;
			_startPosition.y = _player.getSprite()->getPosition().y;
		}

		if (h4fl == 1)
		{
			_fadeTimer += _dTime;

			if (_fadeTimer >= 2.f)
			{
				_tunnelMusic.setVolume(0.f);
				_corruptionSound.stop();
				_corruptionSound.playOnce();
				_h4corrupted = true;
				setScene(S_H4_2);
				_startPosition.x = 36;
				_startPosition.y = 117;
				h4fl = 2;
				_fadeTimer = 0.5f;
			}
		}
		else if (h4fl == 2)
		{
			_fadeTimer -= _dTime / 10.f;
			if (_fadeTimer <= 0.f)
			{
				_fadeTimer = 0.f;
				h4fl = 0;
			}
		}
	}
	else if (_scene == S_CHURCH)
	{
		static int f = 0;
		if (_player.getSprite()->getPosition().x < 10)
		{
			setScene(S_H3);
			_startPosition.x = 177;
			_startPosition.y = _player.getSprite()->getPosition().y;
		}

		if (_h3corrupted && _h4corrupted && _player.getInside(sf::Rect<int>(84, 80, 108, 117)))
		{
			_rWindow.draw(_doorSprite);
			if (_interact)
			{
				setScene(S_CHURCH_I, true);
				_startPosition.x = 96;
				_startPosition.y = 100;
			}
		}

		if (!_h3corrupted || !_h4corrupted)
		{
			_timer0 += _dTime;
			if (_timer0 > 0.3f)
			{
				f = !f;
				_timer0 = 0.f;
			}
			_dSprite.setTextureRect(sf::Rect<int>(0 + f * 24, 0, 24, 40));
			_rWindow.draw(_dSprite);
		}
	}
	else if (_scene == S_CHURCH_I)
	{
		static int hf = 0;
		static bool finalBed = false;

		_timer0 += _dTime;
		if (_timer0 > 0.855f)
		{
			_heartbeatSound.stop();
			_heartbeatSound.playOnce();
			_timer0 = 0.f;
		}
		if (_timer0 > 0.f && _timer0 < 0.3f) hf = 1;
		else hf = 0;
		_dSprite.setTextureRect(sf::Rect<int>(0 + hf * 9, 0, 9, 12));
		_rWindow.draw(_dSprite);

		if (_player.getInside(sf::Rect<int>(137, 96, 175, 119)))
		{
			_rWindow.draw(_bedSprite);
			if (_interact)
			{
				finalBed = true;
			}
		}

		if (finalBed)
		{
			_fadeTimer += _dTime;

			float factor = _fadeTimer / 5.f;
			if (factor < 0.f) factor = 0.f;
			factor = 1.f - factor;
			_heartbeatSound.setVolume(factor);

			if (_fadeTimer >= 5.f)
			{
				setScene(S_HOSPITAL, true);
				_fadeTimer = 0.5f;
			}
		}
	}
	else if (_scene == S_HOSPITAL)
	{
		_fadeTimer += _dTime / 30.f;

		_timer0 += _dTime;
		if (_timer0 >= 25.f) _rWindow.close();
	}
}


void Application::handleEvent()
{
	sf::Event event;

	while (_rWindow.pollEvent(event))
	{
		if (event.type == sf::Event::Closed)
		{
			_rWindow.close();
		}

		if (event.type == sf::Event::KeyPressed && event.key.code == sf::Keyboard::Q)
			_rWindow.close();

		if (event.type == sf::Event::KeyReleased && (event.key.code == sf::Keyboard::F || event.key.code == sf::Keyboard::F11))
		{
			if (_fullscreen)
			{
				_rWindow.create(sf::VideoMode(768, 576), "Crab", sf::Style::Close);
				_rWindow.setView(_view);
			}
			else
			{
				_rWindow.create(sf::VideoMode::getDesktopMode(), "Crab", sf::Style::Fullscreen);
				_rWindow.setView(_view);
				/*
				float ratio = (float)(sf::VideoMode::GetDesktopMode().Width)/(float)(sf::VideoMode::GetDesktopMode().Height);
				float offset = ((128 * ratio) - 128) / -2;
				_RWindow.GetDefaultView().SetFromRect(sf::FloatRect(offset, 0, offset + (128 * ratio), 96));
				*/
			}

			_rWindow.setMouseCursorVisible(false);
			_fullscreen = !_fullscreen;
		}

		if (event.type == sf::Event::MouseMoved)
		{
			_cursorPosition.x = event.mouseMove.x * 192 / _rWindow.getSize().x;
			_cursorPosition.y = event.mouseMove.y * 144 / _rWindow.getSize().y;
			_cursorSprite.setPosition(_cursorPosition);
		}

		if (event.type == sf::Event::MouseButtonReleased && event.mouseButton.button == sf::Mouse::Left) _interact = true;

	}
}


float Application::getDeltaTime() const
{
    return _dTime;
}


sf::Vector2<float> Application::getCursorPosition() const
{
	return _cursorPosition;
}


sf::RenderWindow* Application::getRenderWindow()
{
	return &_rWindow;
}


int Application::getScene() const
{
	return _scene;
}

void Application::setScene(int newScene, bool fade)
{
	_newScene = newScene;
	_fade = fade;
}


int Application::getFade() const
{
	return _fade;
}


Application::~Application()
{
	_corruptionSound.clear();
	_heartbeatSound.clear();
	_bipSound.clear();
	_lightSound.clear();

	_cellMusic.clear();
	_cavernMusic.clear();
	_tunnelMusic.clear();
	alutExit();
}
